// C Source File
// Created 3/5/2005; 10:47:19 PM

#include <tigcclib.h>

#include "TimeUtils.h"
#include "BasicTypes.h"
#include "BasicUtils.h"


void Sleep(uint4 milliseconds)
{
	static int2 firstTime = 1;
	static int2 vti = 0;

	uint4 loops;
	uint4 i;

	if (firstTime)
	{
		firstTime = 0;
		vti = IsVTI();
	}

	if (vti)
	{
		uint2 dummyCounter;

		loops = milliseconds * 430; // 430 was found by testing

		for (i = 0; i < loops; i++)
		{
			dummyCounter++;
		}
	}
	else
	{
		loops = milliseconds / 2.65; // 2.65 was found by testing

	  for (i = 0; i < loops; i++)
	  {
	  	// poke this reg to put CPU to sleep
	    pokeIO(0x600005,0b10111); // allow interrupts 1,2,3,5 to wake us up
	  }
	}
}

void InitTimer(uint2 timer, uint4 milliseconds)
{
	// the default frequency of the programmable rate generator is 20 Hz (50 msec).
	uint4 timerValue = milliseconds/50;

	if (!timerValue)
		timerValue = 1;

	KillTimer(USER_TIMER); // TIOS requires to free the timer prior to use
	OSRegisterTimer (timer, timerValue); // Auto-Int 5 is triggered 20 times per second
}

uint2 CheckTimer(uint2 timer)
{
	if (OSTimerExpired (timer))
		return 1;
	else
		return 0;
}

void RestartTimer(uint2 timer)
{
	OSTimerRestart (timer);
}

void KillTimer(uint2 timer)
{
	OSFreeTimer (timer);
}